/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.filters;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.security.InvalidKeyException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.domain.TemporaryCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.io.InputSuppliers;
import org.jclouds.rest.RequestSigner;

@Singleton
public class RestAuthentication
implements HttpRequestFilter,
RequestSigner {
    private final Supplier<Credentials> creds;
    private final Provider<String> timeStampProvider;
    private final Crypto crypto;

    @Inject
    public RestAuthentication(@org.jclouds.location.Provider Supplier<Credentials> creds, @TimeStamp Provider<String> timeStampProvider, Crypto crypto) {
        this.creds = creds;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials current = this.creds.get();
        if (current instanceof TemporaryCredentials) {
            request = this.replaceSecurityTokenHeader(request, (TemporaryCredentials)TemporaryCredentials.class.cast(current));
        }
        request = this.replaceDateHeader(request, this.timeStampProvider.get());
        String signature = this.sign(this.createStringToSign(request));
        return this.replaceAuthorizationHeader(request, signature);
    }

    private HttpRequest replaceSecurityTokenHeader(HttpRequest request, TemporaryCredentials current) {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-amz-security-token", current.getSessionToken())).build();
    }

    private HttpRequest replaceDateHeader(HttpRequest request, String timestamp) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Date", timestamp)).build();
        return request;
    }

    @Override
    public String createStringToSign(HttpRequest input) {
        return input.getFirstHeaderOrNull("Date");
    }

    @Override
    public String sign(String toSign) {
        try {
            return CryptoStreams.base64(CryptoStreams.mac(InputSuppliers.of(toSign), this.crypto.hmacSHA256(this.creds.get().credential.getBytes(Charsets.UTF_8))));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate(e);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("X-Amzn-Authorization", "AWS3-HTTPS AWSAccessKeyId=" + this.creds.get().identity + ",Algorithm=HmacSHA256,Signature=" + signature)).build();
        return request;
    }
}

