/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.concurrent.internal.SyncProxy;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;

@Singleton
public class ClientProvider<S, A>
implements Provider<S> {
    @Inject
    Injector injector;
    private final Class<?> syncClientType;
    private final Class<?> asyncClientType;
    private final Map<Class<?>, Class<?>> sync2Async;

    @Inject
    ClientProvider(Class<?> syncClientType, Class<?> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        this.asyncClientType = asyncClientType;
        this.syncClientType = syncClientType;
        this.sync2Async = sync2Async;
    }

    @Override
    @Singleton
    public S get() {
        Object client = this.injector.getInstance(Key.get(this.asyncClientType));
        Function<ClassMethodArgsAndReturnVal, Optional<Object>> optionalConverter = this.injector.getInstance(Key.get(new TypeLiteral<Function<ClassMethodArgsAndReturnVal, Optional<Object>>>(){}));
        LoadingCache<ClassMethodArgs, Object> delegateMap = this.injector.getInstance(Key.get(new TypeLiteral<LoadingCache<ClassMethodArgs, Object>>(){}, (Annotation)Names.named("sync")));
        Map<String, Long> timeoutsMap = this.injector.getInstance(Key.get(new TypeLiteral<Map<String, Long>>(){}, (Annotation)Names.named("TIMEOUTS")));
        try {
            return (S)SyncProxy.proxy(optionalConverter, this.syncClientType, client, delegateMap, this.sync2Async, timeoutsMap);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

