/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.loadbalancer.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.ListLoadBalancersStrategy;
import org.jclouds.location.Zone;
import org.jclouds.logging.Logger;
import org.jclouds.rackspace.cloudloadbalancers.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancer;

@Singleton
public class CloudLoadBalancersListLoadBalancersStrategy
implements ListLoadBalancersStrategy {
    @Resource
    @Named(value="jclouds.loadbalancer")
    protected Logger logger = Logger.NULL;
    private final CloudLoadBalancersApi aclient;
    private final Function<LoadBalancer, LoadBalancerMetadata> converter;
    private final ExecutorService executor;
    private final Supplier<Set<String>> zones;

    @Inject
    protected CloudLoadBalancersListLoadBalancersStrategy(CloudLoadBalancersApi aclient, Function<LoadBalancer, LoadBalancerMetadata> converter, @Named(value="jclouds.user-threads") ExecutorService executor, @Zone Supplier<Set<String>> zones) {
        this.aclient = Preconditions.checkNotNull(aclient, "aclient");
        this.zones = Preconditions.checkNotNull(zones, "zones");
        this.converter = Preconditions.checkNotNull(converter, "converter");
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    @Override
    public Iterable<? extends LoadBalancerMetadata> listLoadBalancers() {
        HashSet<LoadBalancerMetadata> loadBalancerMetadatas = Sets.newHashSet();
        for (String zone : this.zones.get()) {
            FluentIterable<LoadBalancerMetadata> lbm = this.aclient.getLoadBalancerApiForZone(zone).list().concat().transform(this.converter);
            for (LoadBalancerMetadata loadBalancerMetadata : lbm) {
                loadBalancerMetadatas.add(loadBalancerMetadata);
            }
        }
        return loadBalancerMetadatas;
    }
}

