/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.functions.ReturnEmptyPaginatedCollectionOnNotFoundOr404;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancerAttributes;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancerRequest;
import org.jclouds.rackspace.cloudloadbalancers.functions.ParseLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.functions.ParseLoadBalancers;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.ReturnEmptyPagedIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={AuthenticateRequest.class})
public interface LoadBalancerAsyncApi {
    @POST
    @ResponseParser(value=ParseLoadBalancer.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/loadbalancers")
    public ListenableFuture<LoadBalancer> create(@WrapWith(value="loadBalancer") LoadBalancerRequest var1);

    @PUT
    @ResponseParser(value=ParseLoadBalancer.class)
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers/{id}")
    public ListenableFuture<Void> update(@PathParam(value="id") int var1, @WrapWith(value="loadBalancer") LoadBalancerAttributes var2);

    @GET
    @ResponseParser(value=ParseLoadBalancers.class)
    @Transform(value=ParseLoadBalancers.ToPagedIterable.class)
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers")
    @ExceptionParser(value=ReturnEmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<PagedIterable<LoadBalancer>> list();

    @GET
    @ResponseParser(value=ParseLoadBalancers.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/loadbalancers")
    public ListenableFuture<IterableWithMarker<LoadBalancer>> list(PaginationOptions var1);

    @GET
    @ResponseParser(value=ParseLoadBalancer.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}")
    public ListenableFuture<LoadBalancer> get(@PathParam(value="id") int var1);

    @DELETE
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}")
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> remove(@PathParam(value="id") int var1);
}

