/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class VirtualIP
implements Comparable<VirtualIP> {
    private int id;
    private String address;
    private Type type;
    private IPVersion ipVersion;

    public static Builder builder() {
        return new Builder();
    }

    VirtualIP() {
    }

    public VirtualIP(int id, String address, Type type, IPVersion ipVersion) {
        Preconditions.checkArgument(id != -1, "id must be specified");
        this.id = id;
        this.address = Preconditions.checkNotNull(address, "address");
        this.type = Preconditions.checkNotNull(type, "type");
        this.ipVersion = Preconditions.checkNotNull(ipVersion, "ipVersion");
    }

    public int getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public Type getType() {
        return this.type;
    }

    public IPVersion getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public int compareTo(VirtualIP arg0) {
        return this.address.compareTo(arg0.address);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("id", this.id).add("address", this.address).add("ipVersion", (Object)this.ipVersion).add("type", (Object)this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualIP that = (VirtualIP)VirtualIP.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    public static enum IPVersion {
        IPV4,
        IPV6,
        UNRECOGNIZED;


        public static IPVersion fromValue(String ipVersion) {
            try {
                return IPVersion.valueOf(Preconditions.checkNotNull(ipVersion, "ipVersion"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        PUBLIC,
        SERVICENET,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf(Preconditions.checkNotNull(type, "type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private int id = -1;
        private String address;
        private Type type;
        private IPVersion ipVersion = IPVersion.IPV4;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder ipVersion(IPVersion ipVersion) {
            this.ipVersion = ipVersion;
            return this;
        }

        public VirtualIP build() {
            return new VirtualIP(this.id, this.address, this.type, this.ipVersion);
        }
    }
}

