/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.domain;

import com.google.common.base.Objects;
import org.jclouds.rackspace.cloudloadbalancers.domain.internal.BaseNode;

public class NodeAttributes {
    protected String condition;
    protected Integer weight;

    public NodeAttributes condition(String condition) {
        this.condition = condition;
        return this;
    }

    public NodeAttributes weight(int weight) {
        this.weight = weight;
        return this;
    }

    public static <T extends BaseNode<T>> NodeAttributes fromNode(T n) {
        return Builder.condition(n.getCondition()).weight(n.getWeight());
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("condition", this.condition).add("weight", this.weight);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.condition, this.weight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeAttributes that = (NodeAttributes)NodeAttributes.class.cast(obj);
        return Objects.equal(this.condition, that.condition) && Objects.equal(this.weight, that.weight);
    }

    public static class Builder {
        public static NodeAttributes condition(BaseNode.Condition condition) {
            return new NodeAttributes().condition(condition.name());
        }

        public static NodeAttributes weight(int weight) {
            return new NodeAttributes().weight(weight);
        }
    }
}

