/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.predicates;

import com.google.common.annotations.Beta;
import java.util.concurrent.Callable;
import org.jclouds.predicates.PredicateWithResult;

@Beta
public abstract class PredicateCallable<Result>
implements PredicateWithResult<Void, Result>,
Callable<Result> {
    Result lastResult;
    Exception lastFailure;

    @Override
    public boolean apply(Void input) {
        try {
            this.lastResult = this.call();
            this.onCompletion();
            return this.isAcceptable(this.lastResult);
        }
        catch (Exception e) {
            this.lastFailure = e;
            this.onFailure();
            return false;
        }
    }

    protected void onFailure() {
    }

    protected void onCompletion() {
    }

    protected boolean isAcceptable(Result result) {
        return result != null;
    }

    @Override
    public Result getResult() {
        return this.lastResult;
    }

    @Override
    public Throwable getLastFailure() {
        return this.lastFailure;
    }
}

