/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.swift.domain.ObjectInfo;

public class ObjectInfoImpl
implements ObjectInfo {
    private final String name;
    private final String container;
    private final URI uri;
    private final byte[] hash;
    private final Long bytes;
    @Named(value="content_type")
    private final String contentType;
    @Named(value="last_modified")
    private final Date lastModified;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromObjectInfoImpl(this);
    }

    @ConstructorProperties(value={"name", "container", "uri", "hash", "bytes", "content_type", "last_modified"})
    protected ObjectInfoImpl(String name, @Nullable String container, @Nullable URI uri, @Nullable byte[] hash, @Nullable Long bytes, @Nullable String contentType, @Nullable Date lastModified) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.container = container;
        this.uri = uri;
        this.hash = hash;
        this.bytes = bytes;
        this.contentType = contentType;
        this.lastModified = lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getContainer() {
        return this.container;
    }

    @Override
    @Nullable
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    @Nullable
    public Long getBytes() {
        return this.bytes;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public Date getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.container);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectInfoImpl that = (ObjectInfoImpl)ObjectInfoImpl.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.container, that.container);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("name", this.name).add("container", this.container).add("uri", this.uri).add("hash", Arrays.toString(this.hash)).add("bytes", this.bytes).add("contentType", this.contentType).add("lastModified", this.lastModified);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(ObjectInfo other) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.name), (Comparable<?>)((Object)other.getName())).compare(this.container, other.getContainer(), Ordering.natural().nullsLast()).result();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String container;
        protected URI uri;
        protected byte[] hash;
        protected Long bytes;
        protected String contentType;
        protected Date lastModified;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T container(String container) {
            this.container = container;
            return this.self();
        }

        public T uri(URI uri) {
            this.uri = uri;
            return this.self();
        }

        public T hash(byte[] hash) {
            this.hash = hash;
            return this.self();
        }

        public T bytes(Long bytes) {
            this.bytes = bytes;
            return this.self();
        }

        public T contentType(String contentType) {
            this.contentType = contentType;
            return this.self();
        }

        public T lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this.self();
        }

        public ObjectInfoImpl build() {
            return new ObjectInfoImpl(this.name, this.container, this.uri, this.hash, this.bytes, this.contentType, this.lastModified);
        }

        public T fromObjectInfoImpl(ObjectInfoImpl in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).container(in.getContainer())).uri(in.getUri())).hash(in.getHash())).bytes(in.getBytes())).contentType(in.getContentType())).lastModified(in.getLastModified());
        }
    }
}

