/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.openstack.swift.domain.SwiftObject;

@Singleton
public class ObjectToBlob
implements Function<SwiftObject, Blob> {
    private final Blob.Factory blobFactory;
    private final ObjectToBlobMetadata object2BlobMd;

    @Inject
    ObjectToBlob(Blob.Factory blobFactory, ObjectToBlobMetadata object2BlobMd) {
        this.blobFactory = blobFactory;
        this.object2BlobMd = object2BlobMd;
    }

    @Override
    public Blob apply(SwiftObject from) {
        if (from == null) {
            return null;
        }
        Blob blob = this.blobFactory.create(this.object2BlobMd.apply(from.getInfo()));
        blob.setPayload(Preconditions.checkNotNull(from.getPayload(), "payload: " + from));
        blob.setAllHeaders(from.getAllHeaders());
        return blob;
    }
}

