/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.domain.ImageStatus;
import org.jclouds.openstack.nova.domain.Resource;

public class Image
extends Resource {
    private final String name;
    private final Integer progress;
    private final String serverRef;
    private final ImageStatus status;
    private final Map<String, String> metadata;
    private final Date created;
    private final Date updated;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromImage(this);
    }

    @ConstructorProperties(value={"id", "links", "orderedSelfReferences", "name", "progress", "serverRef", "status", "metadata", "created", "updated"})
    protected Image(int id, List<Map<String, String>> links, @Nullable Map<Resource.LinkType, URI> orderedSelfReferences, @Nullable String name, @Nullable Integer progress, @Nullable String serverRef, @Nullable ImageStatus status, @Nullable Map<String, String> metadata, @Nullable Date created, @Nullable Date updated) {
        super(id, links, orderedSelfReferences);
        this.name = name;
        this.progress = progress;
        this.serverRef = serverRef;
        this.status = status == null ? ImageStatus.UNKNOWN : status;
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
        this.created = created;
        this.updated = updated;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Integer getProgress() {
        return this.progress;
    }

    @Nullable
    public String getServerRef() {
        return this.serverRef;
    }

    @Nullable
    public ImageStatus getStatus() {
        return this.status;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.name, this.serverRef);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Image that = (Image)Image.class.cast(obj);
        return super.equals(that) && Objects.equal(this.name, that.name) && Objects.equal(this.serverRef, that.serverRef);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("name", this.name).add("progress", this.progress).add("serverRef", this.serverRef).add("status", (Object)this.status).add("metadata", this.metadata).add("created", this.created).add("updated", this.updated);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String name;
        protected Integer progress;
        protected String serverRef;
        protected ImageStatus status;
        protected Map<String, String> metadata = ImmutableMap.of();
        protected Date created;
        protected Date updated;

        public T name(String name) {
            this.name = name;
            return (T)((Builder)this.self());
        }

        public T progress(Integer progress) {
            this.progress = progress;
            return (T)((Builder)this.self());
        }

        public T serverRef(String serverRef) {
            this.serverRef = serverRef;
            return (T)((Builder)this.self());
        }

        public T status(ImageStatus status) {
            this.status = status;
            return (T)((Builder)this.self());
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
            return (T)((Builder)this.self());
        }

        public T created(Date created) {
            this.created = created;
            return (T)((Builder)this.self());
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Builder)this.self());
        }

        public Image build() {
            return new Image(this.id, this.links, this.orderedSelfReferences, this.name, this.progress, this.serverRef, this.status, this.metadata, this.created, this.updated);
        }

        public T fromImage(Image in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromResource(in)).id(in.getId())).name(in.getName())).progress(in.getProgress())).serverRef(in.getServerRef())).status(in.getStatus())).metadata(in.getMetadata())).created(in.getCreated())).updated(in.getUpdated());
        }
    }
}

