/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions;

import com.google.common.base.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.v2_0.AuthenticationApi;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.PasswordCredentials;
import org.jclouds.openstack.keystone.v2_0.functions.internal.BaseAuthenticator;

@CredentialType(value="passwordCredentials")
@Singleton
public class AuthenticatePasswordCredentials
extends BaseAuthenticator<PasswordCredentials> {
    protected final AuthenticationApi api;

    @Inject
    public AuthenticatePasswordCredentials(AuthenticationApi api) {
        this.api = api;
    }

    @Override
    protected Access authenticateWithTenantName(Optional<String> tenantName, PasswordCredentials apiAccessKeyCredentials) {
        return this.api.authenticateWithTenantNameAndCredentials(tenantName.orNull(), apiAccessKeyCredentials);
    }

    @Override
    protected Access authenticateWithTenantId(Optional<String> tenantId, PasswordCredentials apiAccessKeyCredentials) {
        return this.api.authenticateWithTenantIdAndCredentials(tenantId.orNull(), apiAccessKeyCredentials);
    }

    @Override
    public PasswordCredentials createCredentials(String identity, String credential) {
        return PasswordCredentials.createWithUsernameAndPassword(identity, credential);
    }

    public String toString() {
        return "authenticatePasswordCredentials()";
    }
}

