/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetImageListOptions
extends BaseHttpRequestOptions {
    public GetImageListOptions setType(ServerImageType imageType) {
        Preconditions.checkState(!this.queryParameters.containsKey("image.type"), "Can't have duplicate image type restrictions");
        this.queryParameters.put("image.type", imageType.toString());
        return this;
    }

    public GetImageListOptions setState(ServerImageState imageState) {
        Preconditions.checkState(!this.queryParameters.containsKey("image.state"), "Can't have duplicate image state restrictions");
        this.queryParameters.put("image.state", imageState.toString());
        return this;
    }

    public GetImageListOptions onlyPublic() {
        Preconditions.checkState(!this.queryParameters.containsKey("isPublic"), "Can't have duplicate image visibility restrictions");
        this.queryParameters.put("isPublic", "true");
        return this;
    }

    public GetImageListOptions onlyPrivate() {
        Preconditions.checkState(!this.queryParameters.containsKey("isPublic"), "Can't have duplicate image visibility restrictions");
        this.queryParameters.put("isPublic", "false");
        return this;
    }

    public GetImageListOptions inDatacenter(String datacenterId) {
        Preconditions.checkState(!this.queryParameters.containsKey("datacenter"), "Can't have duplicate datacenter id");
        this.queryParameters.put("datacenter", datacenterId);
        return this;
    }

    public GetImageListOptions maxItemsNumber(Integer maxNumber) {
        Preconditions.checkState(!this.queryParameters.containsKey("num_items"), "Can't have duplicate parameter of max returned items");
        this.queryParameters.put("num_items", maxNumber.toString());
        return this;
    }

    public static class Builder {
        public static GetImageListOptions maxItems(int maxNumber) {
            return new GetImageListOptions().maxItemsNumber(maxNumber);
        }

        public static GetImageListOptions inDatacenter(String datacenterId) {
            return new GetImageListOptions().inDatacenter(Preconditions.checkNotNull(datacenterId, "datacenterId"));
        }

        public static GetImageListOptions publicWebServers() {
            return new GetImageListOptions().setState(ServerImageState.AVAILABLE).setType(ServerImageType.WEB_APPLICATION_SERVER).onlyPublic();
        }

        public static GetImageListOptions publicDatabaseServers() {
            return new GetImageListOptions().setState(ServerImageState.AVAILABLE).setType(ServerImageType.DATABASE_SERVER).onlyPublic();
        }
    }
}

