/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;

public class Realm {
    private final URI href;
    private final String id;
    @Nullable
    private final String limit;
    private final String name;
    private final State state;

    public Realm(URI href, String id, String name, @Nullable String limit, State state) {
        this.href = Preconditions.checkNotNull(href, "href");
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.limit = limit;
        this.state = Preconditions.checkNotNull(state, "state");
    }

    public URI getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getLimit() {
        return this.limit;
    }

    public State getState() {
        return this.state;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Realm other = (Realm)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.limit == null ? other.limit != null : !this.limit.equals(other.limit)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.state == other.state;
    }

    public String toString() {
        return "[href=" + this.href + ", id=" + this.id + ", limit=" + this.limit + ", name=" + this.name + ", state=" + (Object)((Object)this.state) + "]";
    }

    public static enum State {
        AVAILABLE,
        UNAVAILABLE,
        UNRECOGNIZED;


        public static State fromValue(String state) {
            try {
                return State.valueOf(Preconditions.checkNotNull(state, "state"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

