/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateIPForwardingRuleOptions;
import org.jclouds.cloudstack.options.ListIPForwardingRulesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface NATAsyncClient {
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<IPForwardingRule>> listIPForwardingRules(ListIPForwardingRulesOptions ... var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<IPForwardingRule> getIPForwardingRule(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Set<IPForwardingRule>> getIPForwardingRulesForIPAddress(@QueryParam(value="ipaddressid") String var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listIpForwardingRules", "true"})
    @SelectJson(value={"ipforwardingrule"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Set<IPForwardingRule>> getIPForwardingRulesForVirtualMachine(@QueryParam(value="virtualmachineid") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"createIpForwardingRule"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> createIPForwardingRule(@QueryParam(value="ipaddressid") String var1, @QueryParam(value="protocol") String var2, @QueryParam(value="startport") int var3, CreateIPForwardingRuleOptions ... var4);

    @GET
    @QueryParams(keys={"command"}, values={"enableStaticNat"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Void> enableStaticNATForVirtualMachine(@QueryParam(value="virtualmachineid") String var1, @QueryParam(value="ipaddressid") String var2);

    @GET
    @QueryParams(keys={"command"}, values={"deleteIpForwardingRule"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<String> deleteIPForwardingRule(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"disableStaticNat"})
    @SelectJson(value={"jobid"})
    @Consumes(value={"application/json"})
    public ListenableFuture<String> disableStaticNATOnPublicIP(@QueryParam(value="ipaddressid") String var1);
}

