/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.javax.annotation.Nullable;

public class Zone
implements Comparable<Zone> {
    private final String id;
    private final String description;
    private final String displayText;
    private final String DNS1;
    private final String DNS2;
    private final String domain;
    private final String domainId;
    private final String guestCIDRAddress;
    private final String internalDNS1;
    private final String internalDNS2;
    private final String name;
    private final NetworkType networkType;
    private final String VLAN;
    private final boolean securityGroupsEnabled;
    private final AllocationState allocationState;
    private final String dhcpProvider;
    private final String zoneToken;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromZone(this);
    }

    @ConstructorProperties(value={"id", "description", "displaytext", "dns1", "dns2", "domain", "domainid", "guestcidraddress", "internaldns1", "internaldns2", "name", "networktype", "vlan", "securitygroupsenabled", "allocationstate", "dhcpprovider", "zonetoken"})
    protected Zone(String id, @Nullable String description, @Nullable String displayText, @Nullable String DNS1, @Nullable String DNS2, @Nullable String domain, @Nullable String domainId, @Nullable String guestCIDRAddress, @Nullable String internalDNS1, @Nullable String internalDNS2, @Nullable String name, @Nullable NetworkType networkType, @Nullable String VLAN, boolean securityGroupsEnabled, @Nullable AllocationState allocationState, @Nullable String dhcpProvider, @Nullable String zoneToken) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.description = description;
        this.displayText = displayText;
        this.DNS1 = DNS1;
        this.DNS2 = DNS2;
        this.domain = domain;
        this.domainId = domainId;
        this.guestCIDRAddress = guestCIDRAddress;
        this.internalDNS1 = internalDNS1;
        this.internalDNS2 = internalDNS2;
        this.name = name;
        this.networkType = networkType;
        this.VLAN = VLAN;
        this.securityGroupsEnabled = securityGroupsEnabled;
        this.allocationState = allocationState;
        this.dhcpProvider = dhcpProvider;
        this.zoneToken = zoneToken;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    public List<String> getDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.DNS1 != null && !"".equals(this.DNS1)) {
            builder.add(this.DNS1);
        }
        if (this.DNS2 != null && !"".equals(this.DNS2)) {
            builder.add(this.DNS2);
        }
        return builder.build();
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getGuestCIDRAddress() {
        return this.guestCIDRAddress;
    }

    public List<String> getInternalDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.internalDNS1 != null && !"".equals(this.internalDNS1)) {
            builder.add(this.internalDNS1);
        }
        if (this.internalDNS2 != null && !"".equals(this.internalDNS2)) {
            builder.add(this.internalDNS2);
        }
        return builder.build();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Nullable
    public String getVLAN() {
        return this.VLAN;
    }

    public boolean isSecurityGroupsEnabled() {
        return this.securityGroupsEnabled;
    }

    @Nullable
    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    @Nullable
    public String getDhcpProvider() {
        return this.dhcpProvider;
    }

    @Nullable
    public String getZoneToken() {
        return this.zoneToken;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.description, this.displayText, this.DNS1, this.DNS2, this.domain, this.domainId, this.guestCIDRAddress, this.internalDNS1, this.internalDNS2, this.name, this.networkType, this.VLAN, this.securityGroupsEnabled, this.allocationState, this.dhcpProvider, this.zoneToken});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Zone that = (Zone)Zone.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.description, that.description) && Objects.equal(this.displayText, that.displayText) && Objects.equal(this.DNS1, that.DNS1) && Objects.equal(this.DNS2, that.DNS2) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.guestCIDRAddress, that.guestCIDRAddress) && Objects.equal(this.internalDNS1, that.internalDNS1) && Objects.equal(this.internalDNS2, that.internalDNS2) && Objects.equal(this.name, that.name) && Objects.equal((Object)this.networkType, (Object)that.networkType) && Objects.equal(this.VLAN, that.VLAN) && Objects.equal(this.securityGroupsEnabled, that.securityGroupsEnabled) && Objects.equal((Object)this.allocationState, (Object)that.allocationState) && Objects.equal(this.dhcpProvider, that.dhcpProvider) && Objects.equal(this.zoneToken, that.zoneToken);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("description", this.description).add("displayText", this.displayText).add("DNS1", this.DNS1).add("DNS2", this.DNS2).add("domain", this.domain).add("domainId", this.domainId).add("guestCIDRAddress", this.guestCIDRAddress).add("internalDNS1", this.internalDNS1).add("internalDNS2", this.internalDNS2).add("name", this.name).add("networkType", (Object)this.networkType).add("VLAN", this.VLAN).add("securityGroupsEnabled", this.securityGroupsEnabled).add("allocationState", (Object)this.allocationState).add("dhcpProvider", this.dhcpProvider).add("zoneToken", this.zoneToken);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Zone o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String description;
        protected String displayText;
        protected String DNS1;
        protected String DNS2;
        protected String domain;
        protected String domainId;
        protected String guestCIDRAddress;
        protected String internalDNS1;
        protected String internalDNS2;
        protected String name;
        protected NetworkType networkType;
        protected String VLAN;
        protected boolean securityGroupsEnabled;
        protected AllocationState allocationState;
        protected String dhcpProvider;
        protected String zoneToken;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T DNS(List<String> DNS) {
            if (!DNS.isEmpty()) {
                this.DNS1 = DNS.get(0);
            }
            if (DNS.size() > 1) {
                this.DNS2 = DNS.get(1);
            }
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T guestCIDRAddress(String guestCIDRAddress) {
            this.guestCIDRAddress = guestCIDRAddress;
            return this.self();
        }

        public T internalDNS(List<String> DNS) {
            if (!DNS.isEmpty()) {
                this.internalDNS1 = DNS.get(0);
            }
            if (DNS.size() > 1) {
                this.internalDNS2 = DNS.get(1);
            }
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this.self();
        }

        public T VLAN(String VLAN) {
            this.VLAN = VLAN;
            return this.self();
        }

        public T securityGroupsEnabled(boolean securityGroupsEnabled) {
            this.securityGroupsEnabled = securityGroupsEnabled;
            return this.self();
        }

        public T allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this.self();
        }

        public T dhcpProvider(String dhcpProvider) {
            this.dhcpProvider = dhcpProvider;
            return this.self();
        }

        public T zoneToken(String zoneToken) {
            this.zoneToken = zoneToken;
            return this.self();
        }

        public Zone build() {
            return new Zone(this.id, this.description, this.displayText, this.DNS1, this.DNS2, this.domain, this.domainId, this.guestCIDRAddress, this.internalDNS1, this.internalDNS2, this.name, this.networkType, this.VLAN, this.securityGroupsEnabled, this.allocationState, this.dhcpProvider, this.zoneToken);
        }

        public T fromZone(Zone in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).description(in.getDescription())).displayText(in.getDisplayText())).DNS(in.getDNS())).domain(in.getDomain())).domainId(in.getDomainId())).guestCIDRAddress(in.getGuestCIDRAddress())).internalDNS(in.getInternalDNS())).name(in.getName())).networkType(in.getNetworkType())).VLAN(in.getVLAN())).securityGroupsEnabled(in.isSecurityGroupsEnabled())).allocationState(in.getAllocationState())).dhcpProvider(in.getDhcpProvider())).zoneToken(in.getZoneToken());
        }
    }
}

