/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum StorageType {
    LOCAL,
    SHARED,
    UNRECOGNIZED;


    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    public static StorageType fromValue(String type) {
        try {
            return StorageType.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(type, "type")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

