/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.concurrent.Futures;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.Retryables;

@Singleton
public class CloudServersImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudServersClient client;
    private final ExecutorService executor;
    private final PredicateWithResult<Integer, org.jclouds.compute.domain.Image> imageAvailablePredicate;
    @Inject(optional=true)
    @Named(value="IMAGE_MAX_WAIT")
    private long maxWait = 3600L;
    @Inject(optional=true)
    @Named(value="IMAGE_WAIT_PERIOD")
    private long waitPeriod = 1L;

    @javax.inject.Inject
    public CloudServersImageExtension(CloudServersClient client, @Named(value="jclouds.user-threads") ExecutorService userThreads, PredicateWithResult<Integer, org.jclouds.compute.domain.Image> imageAvailablePredicate) {
        this.client = Preconditions.checkNotNull(client);
        this.executor = userThreads;
        this.imageAvailablePredicate = imageAvailablePredicate;
    }

    @Override
    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        Server server = this.client.getServer(Integer.parseInt(id));
        if (server == null) {
            throw new NoSuchElementException("Cannot find server with id: " + id);
        }
        CloneImageTemplate template = new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
        return template;
    }

    @Override
    public ListenableFuture<org.jclouds.compute.domain.Image> createImage(ImageTemplate template) {
        Preconditions.checkState(template instanceof CloneImageTemplate, " openstack-nova only supports creating images through cloning.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        final Image image = this.client.createImageFromServer(cloneTemplate.getName(), Integer.parseInt(cloneTemplate.getSourceNodeId()));
        return Futures.makeListenable(this.executor.submit(new Callable<org.jclouds.compute.domain.Image>(){

            @Override
            public org.jclouds.compute.domain.Image call() throws Exception {
                return (org.jclouds.compute.domain.Image)Retryables.retryGettingResultOrFailing(CloudServersImageExtension.this.imageAvailablePredicate, image.getId(), CloudServersImageExtension.this.maxWait, CloudServersImageExtension.this.waitPeriod, TimeUnit.SECONDS, "Image was not created within the time limit, Giving up! [Limit: " + CloudServersImageExtension.this.maxWait + " secs.]");
            }
        }), this.executor);
    }

    @Override
    public boolean deleteImage(String id) {
        try {
            this.client.deleteImage(Integer.parseInt(id));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

