/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudfiles.CloudFilesClient;

@Singleton
public class EnableCDNAndCache
implements Function<String, URI> {
    private final LoadingCache<String, URI> cdnContainer;
    private final CloudFilesClient sync;

    @Inject
    public EnableCDNAndCache(CloudFilesClient sync, LoadingCache<String, URI> cdnContainer) {
        this.sync = sync;
        this.cdnContainer = cdnContainer;
    }

    @Override
    public URI apply(String input) {
        URI uri = this.sync.enableCDN(input);
        this.cdnContainer.put(input, uri);
        return uri;
    }
}

