/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.suppliers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;

public class SupplyFromProviderURIOrNodesProperty
implements Supplier<InputStream>,
Function<URI, InputStream> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<URI> url;
    @Inject(optional=true)
    @Named(value="byon.nodes")
    @VisibleForTesting
    String nodes;

    @VisibleForTesting
    public SupplyFromProviderURIOrNodesProperty(URI url) {
        this(Suppliers.ofInstance(Preconditions.checkNotNull(url, "url")));
    }

    @Inject
    public SupplyFromProviderURIOrNodesProperty(@Provider Supplier<URI> url) {
        this.url = Preconditions.checkNotNull(url, "url");
    }

    @Override
    public InputStream get() {
        if (this.nodes != null) {
            return Strings2.toInputStream(this.nodes);
        }
        return this.apply(this.url.get());
    }

    public String toString() {
        return "[url=" + this.url + "]";
    }

    @Override
    public InputStream apply(URI input) {
        try {
            if (input.getScheme() != null && input.getScheme().equals("classpath")) {
                return this.getClass().getResourceAsStream(input.getPath());
            }
            return input.toURL().openStream();
        }
        catch (IOException e) {
            this.logger.error(e, "URI could not be read: %s", this.url);
            throw Throwables.propagate(e);
        }
    }
}

