/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.http.HttpUtils;

@Singleton
public class BlobPropertiesToBlobMetadata
implements Function<BlobProperties, MutableBlobMetadata> {
    private final IfDirectoryReturnNameStrategy ifDirectoryReturnName;
    private final LoadingCache<String, PublicAccess> containerAcls;

    @Inject
    public BlobPropertiesToBlobMetadata(IfDirectoryReturnNameStrategy ifDirectoryReturnName, LoadingCache<String, PublicAccess> containerAcls) {
        this.ifDirectoryReturnName = Preconditions.checkNotNull(ifDirectoryReturnName, "ifDirectoryReturnName");
        this.containerAcls = Preconditions.checkNotNull(containerAcls, "containerAcls");
    }

    @Override
    public MutableBlobMetadata apply(BlobProperties from) {
        String directoryName;
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        HttpUtils.copy(from.getContentMetadata(), to.getContentMetadata());
        to.setUserMetadata(from.getMetadata());
        to.setETag(from.getETag());
        to.setLastModified(from.getLastModified());
        to.setName(from.getName());
        to.setContainer(from.getContainer());
        to.setUri(from.getUrl());
        if (from.getContainer() != null) {
            try {
                PublicAccess containerAcl = this.containerAcls.getUnchecked(from.getContainer());
                if (containerAcl != PublicAccess.PRIVATE) {
                    to.setPublicUri(from.getUrl());
                }
            }
            catch (CacheLoader.InvalidCacheLoadException e) {
                // empty catch block
            }
        }
        if ((directoryName = this.ifDirectoryReturnName.execute(to)) != null) {
            to.setName(directoryName);
            to.setType(StorageType.RELATIVE_PATH);
        } else {
            to.setType(StorageType.BLOB);
        }
        return to;
    }
}

