/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.azureblob.blobstore.functions.ListBlobsResponseToResourceList;
import org.jclouds.azureblob.blobstore.functions.ListOptionsToListBlobsOptions;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;

@Singleton
public class AzureBlobStore
extends BaseBlobStore {
    private final AzureBlobClient sync;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions;
    private final ListBlobsResponseToResourceList azure2BlobStoreResourceList;
    private final AzureBlobToBlob azureBlob2Blob;
    private final BlobToAzureBlob blob2AzureBlob;
    private final BlobPropertiesToBlobMetadata blob2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;

    @Inject
    AzureBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AzureBlobClient sync, ContainerToResourceMetadata container2ResourceMd, ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions, ListBlobsResponseToResourceList azure2BlobStoreResourceList, AzureBlobToBlob azureBlob2Blob, BlobToAzureBlob blob2AzureBlob, BlobPropertiesToBlobMetadata blob2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions) {
        super(context, blobUtils, defaultLocation, locations);
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.container2ResourceMd = Preconditions.checkNotNull(container2ResourceMd, "container2ResourceMd");
        this.blobStore2AzureContainerListOptions = Preconditions.checkNotNull(blobStore2AzureContainerListOptions, "blobStore2AzureContainerListOptions");
        this.azure2BlobStoreResourceList = Preconditions.checkNotNull(azure2BlobStoreResourceList, "azure2BlobStoreResourceList");
        this.azureBlob2Blob = Preconditions.checkNotNull(azureBlob2Blob, "azureBlob2Blob");
        this.blob2AzureBlob = Preconditions.checkNotNull(blob2AzureBlob, "blob2AzureBlob");
        this.blob2BlobMd = Preconditions.checkNotNull(blob2BlobMd, "blob2BlobMd");
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        return new Function<BoundedSet<ContainerProperties>, PageSet<? extends StorageMetadata>>(){

            @Override
            public PageSet<? extends StorageMetadata> apply(BoundedSet<ContainerProperties> from) {
                return new PageSetImpl<StorageMetadata>(Iterables.transform(from, AzureBlobStore.this.container2ResourceMd), from.getNextMarker());
            }
        }.apply(this.sync.listContainers(ListOptions.Builder.includeMetadata()));
    }

    @Override
    public boolean containerExists(String container) {
        return this.sync.containerExists(container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container) {
        return this.sync.createContainer(container, new CreateContainerOptions[0]);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBlobsOptions azureOptions = this.blobStore2AzureContainerListOptions.apply(options);
        return this.azure2BlobStoreResourceList.apply(this.sync.listBlobs(container, azureOptions.includeMetadata()));
    }

    @Override
    public void deleteContainer(String container) {
        this.sync.deleteContainer(container);
    }

    @Override
    public boolean blobExists(String container, String key) {
        return this.sync.blobExists(container, key);
    }

    @Override
    public Blob getBlob(String container, String key, org.jclouds.blobstore.options.GetOptions options) {
        GetOptions azureOptions = this.blob2ObjectGetOptions.apply(options);
        return this.azureBlob2Blob.apply(this.sync.getBlob(container, key, azureOptions));
    }

    @Override
    public String putBlob(String container, Blob blob) {
        return this.sync.putBlob(container, this.blob2AzureBlob.apply(blob));
    }

    @Override
    public String putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    @Override
    public void removeBlob(String container, String key) {
        this.sync.deleteBlob(container, key);
    }

    @Override
    public BlobMetadata blobMetadata(String container, String key) {
        return this.blob2BlobMd.apply(this.sync.getBlobProperties(container, key));
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        throw new UnsupportedOperationException("please use deleteContainer");
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, org.jclouds.blobstore.options.CreateContainerOptions options) {
        CreateContainerOptions createContainerOptions = new CreateContainerOptions();
        if (options.isPublicRead()) {
            createContainerOptions.withPublicAccess(PublicAccess.CONTAINER);
        }
        return this.sync.createContainer(container, createContainerOptions);
    }
}

