/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.binders.BindLaunchSpecificationToFormParams;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.domain.Spot;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.options.DescribeSpotPriceHistoryOptions;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.aws.ec2.xml.DescribeSpotPriceHistoryResponseHandler;
import org.jclouds.aws.ec2.xml.SpotInstanceHandler;
import org.jclouds.aws.ec2.xml.SpotInstancesHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface SpotInstanceAsyncClient {
    @Named(value="ec2:DescribeSpotInstanceRequests")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSpotInstanceRequests"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=SpotInstancesHandler.class)
    public ListenableFuture<? extends Set<SpotInstanceRequest>> describeSpotInstanceRequestsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="ec2:RequestSpotInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RequestSpotInstances"})
    @XMLResponseParser(value=SpotInstanceHandler.class)
    public ListenableFuture<SpotInstanceRequest> requestSpotInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SpotPrice") float var2, @FormParam(value="LaunchSpecification.ImageId") String var3, @FormParam(value="LaunchSpecification.InstanceType") String var4);

    @Named(value="ec2:RequestSpotInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RequestSpotInstances"})
    @XMLResponseParser(value=SpotInstancesHandler.class)
    public ListenableFuture<? extends Set<SpotInstanceRequest>> requestSpotInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SpotPrice") float var2, @FormParam(value="InstanceCount") int var3, @BinderParam(value=BindLaunchSpecificationToFormParams.class) LaunchSpecification var4, RequestSpotInstancesOptions ... var5);

    @Named(value="ec2:DescribeSpotPriceHistory")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSpotPriceHistory"})
    @XMLResponseParser(value=DescribeSpotPriceHistoryResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<Spot>> describeSpotPriceHistoryInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, DescribeSpotPriceHistoryOptions ... var2);

    @Named(value="ec2:CancelSpotInstanceRequests")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CancelSpotInstanceRequests"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> cancelSpotInstanceRequestsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);
}

