/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Preconditions2;

public class AWSEC2TemplateOptions
extends EC2TemplateOptions
implements Cloneable {
    private boolean monitoringEnabled;
    private String placementGroup = null;
    private boolean noPlacementGroup;
    private String subnetId;
    private Float spotPrice;
    private RequestSpotInstancesOptions spotOptions = RequestSpotInstancesOptions.NONE;
    private Set<String> groupIds = ImmutableSet.of();
    public static final AWSEC2TemplateOptions NONE = new AWSEC2TemplateOptions();

    @Override
    public AWSEC2TemplateOptions clone() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof AWSEC2TemplateOptions) {
            AWSEC2TemplateOptions eTo = (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(to);
            if (this.getSubnetId() != null) {
                eTo.subnetId(this.getSubnetId());
            }
            if (this.isMonitoringEnabled()) {
                eTo.enableMonitoring();
            }
            if (!this.shouldAutomaticallyCreatePlacementGroup()) {
                eTo.noPlacementGroup();
            }
            if (this.getPlacementGroup() != null) {
                eTo.placementGroup(this.getPlacementGroup());
            }
            if (this.getGroupIds().size() > 0) {
                eTo.securityGroupIds(this.getGroupIds());
            }
            if (this.getSpotPrice() != null) {
                eTo.spotPrice(this.getSpotPrice());
            }
            if (this.getSpotOptions() != null) {
                eTo.spotOptions(this.getSpotOptions());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSEC2TemplateOptions that = (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(o);
        return super.equals(that) && Objects.equal(this.monitoringEnabled, that.monitoringEnabled) && Objects.equal(this.placementGroup, that.placementGroup) && Objects.equal(this.noPlacementGroup, that.noPlacementGroup) && Objects.equal(this.subnetId, that.subnetId) && Objects.equal(this.spotPrice, that.spotPrice) && Objects.equal(this.spotOptions, that.spotOptions) && Objects.equal(this.groupIds, that.groupIds);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.monitoringEnabled, this.placementGroup, this.noPlacementGroup, this.subnetId, this.spotPrice, this.spotOptions, this.groupIds);
    }

    @Override
    public Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = super.string();
        if (this.monitoringEnabled) {
            toString.add("monitoringEnabled", this.monitoringEnabled);
        }
        toString.add("placementGroup", this.placementGroup);
        if (this.noPlacementGroup) {
            toString.add("noPlacementGroup", this.noPlacementGroup);
        }
        toString.add("subnetId", this.subnetId);
        toString.add("spotPrice", this.spotPrice);
        if (this.spotOptions != RequestSpotInstancesOptions.NONE) {
            toString.add("spotOptions", this.spotOptions);
        }
        if (this.groupIds.size() != 0) {
            toString.add("groupIds", this.groupIds);
        }
        return toString;
    }

    public AWSEC2TemplateOptions enableMonitoring() {
        this.monitoringEnabled = true;
        return this;
    }

    public AWSEC2TemplateOptions placementGroup(String placementGroup) {
        Preconditions.checkNotNull(placementGroup, "use noPlacementGroup option to request boot without a keypair");
        Preconditions.checkState(!this.noPlacementGroup, "you cannot specify both options placementGroup and noPlacementGroup");
        Preconditions2.checkNotEmpty(placementGroup, "placementGroup must be non-empty");
        this.placementGroup = placementGroup;
        return this;
    }

    public AWSEC2TemplateOptions noPlacementGroup() {
        Preconditions.checkState(this.placementGroup == null, "you cannot specify both options placementGroup and noPlacementGroup");
        this.noPlacementGroup = true;
        return this;
    }

    public AWSEC2TemplateOptions subnetId(String subnetId) {
        Preconditions.checkNotNull(subnetId, "subnetId cannot be null");
        Preconditions2.checkNotEmpty(subnetId, "subnetId must be non-empty");
        this.subnetId = subnetId;
        return this;
    }

    public AWSEC2TemplateOptions spotPrice(Float spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    public AWSEC2TemplateOptions spotOptions(RequestSpotInstancesOptions spotOptions) {
        this.spotOptions = spotOptions != null ? spotOptions : RequestSpotInstancesOptions.NONE;
        return this;
    }

    public AWSEC2TemplateOptions securityGroupIds(String ... groupIds) {
        return this.securityGroupIds(ImmutableSet.copyOf(groupIds));
    }

    public AWSEC2TemplateOptions securityGroupIds(Iterable<String> groupIds) {
        Preconditions.checkArgument(Iterables.size(groupIds) > 0, "you must specify at least one security group");
        for (String groupId : groupIds) {
            Preconditions2.checkNotEmpty(groupId, "all security groups must be non-empty");
        }
        this.groupIds = ImmutableSet.copyOf(groupIds);
        return this;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    public AWSEC2TemplateOptions blockDeviceMappings(Iterable<? extends BlockDeviceMapping> blockDeviceMappings) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.blockDeviceMappings(blockDeviceMappings));
    }

    @Override
    public AWSEC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.userMetadata((Map)userMetadata));
    }

    @Override
    public AWSEC2TemplateOptions userMetadata(String key, String value) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.userMetadata(key, value));
    }

    @Override
    public AWSEC2TemplateOptions keyPair(String keyPair) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.keyPair(keyPair));
    }

    @Override
    public AWSEC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, Integer sizeInGib, boolean deleteOnTermination) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.mapEBSSnapshotToDeviceName(deviceName, snapshotId, sizeInGib, deleteOnTermination));
    }

    @Override
    public AWSEC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.mapEphemeralDeviceToDeviceName(deviceName, virtualName));
    }

    @Override
    public AWSEC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.mapNewVolumeToDeviceName(deviceName, sizeInGib, deleteOnTermination));
    }

    @Override
    public AWSEC2TemplateOptions noKeyPair() {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.noKeyPair());
    }

    @Override
    public AWSEC2TemplateOptions securityGroups(Iterable<String> groupIds) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.securityGroups(groupIds));
    }

    @Override
    public AWSEC2TemplateOptions securityGroups(String ... groupIds) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.securityGroups(groupIds));
    }

    @Override
    public AWSEC2TemplateOptions unmapDeviceNamed(String deviceName) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.unmapDeviceNamed(deviceName));
    }

    @Override
    public AWSEC2TemplateOptions userData(byte[] unencodedData) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.userData(unencodedData));
    }

    @Override
    public AWSEC2TemplateOptions blockOnPort(int port, int seconds) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public AWSEC2TemplateOptions inboundPorts(int ... ports) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public AWSEC2TemplateOptions authorizePublicKey(String publicKey) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public AWSEC2TemplateOptions installPrivateKey(String privateKey) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    public AWSEC2TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    @Override
    public AWSEC2TemplateOptions dontAuthorizePublicKey() {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    @Override
    public AWSEC2TemplateOptions nameTask(String name) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public AWSEC2TemplateOptions runAsRoot(boolean runAsRoot) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public AWSEC2TemplateOptions runScript(Statement script) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginPassword(String password) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginUser(String loginUser) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public AWSEC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public boolean shouldAutomaticallyCreatePlacementGroup() {
        return !this.noPlacementGroup;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Float getSpotPrice() {
        return this.spotPrice;
    }

    public RequestSpotInstancesOptions getSpotOptions() {
        return this.spotOptions;
    }

    public static class Builder {
        public static AWSEC2TemplateOptions overrideLoginUser(String user) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static AWSEC2TemplateOptions overrideLoginPassword(String password) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static AWSEC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static AWSEC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static AWSEC2TemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static AWSEC2TemplateOptions securityGroupIds(String ... groupNames) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.securityGroupIds(groupNames));
        }

        public static AWSEC2TemplateOptions securityGroupIds(Iterable<String> groupNames) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.securityGroupIds(groupNames));
        }

        public static AWSEC2TemplateOptions blockDeviceMappings(Set<? extends BlockDeviceMapping> blockDeviceMappings) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.blockDeviceMappings(blockDeviceMappings);
        }

        public static AWSEC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.mapEBSSnapshotToDeviceName(deviceName, snapshotId, sizeInGib, deleteOnTermination);
        }

        public static AWSEC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.mapNewVolumeToDeviceName(deviceName, sizeInGib, deleteOnTermination);
        }

        public static AWSEC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.mapEphemeralDeviceToDeviceName(deviceName, virtualName);
        }

        public static AWSEC2TemplateOptions unmapDeviceNamed(String deviceName) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.unmapDeviceNamed(deviceName);
        }

        public static AWSEC2TemplateOptions securityGroups(String ... groupIds) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.securityGroups(groupIds);
        }

        public static AWSEC2TemplateOptions securityGroups(Iterable<String> groupIds) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.securityGroups((Iterable)groupIds);
        }

        public static AWSEC2TemplateOptions keyPair(String keyPair) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.keyPair(keyPair);
        }

        public static AWSEC2TemplateOptions userData(byte[] unencodedData) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.userData(unencodedData);
        }

        public static AWSEC2TemplateOptions noKeyPair() {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.noKeyPair();
        }

        public static AWSEC2TemplateOptions placementGroup(String placementGroup) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.placementGroup(placementGroup);
        }

        public static AWSEC2TemplateOptions noPlacementGroup() {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.noPlacementGroup();
        }

        public static AWSEC2TemplateOptions enableMonitoring() {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.enableMonitoring();
        }

        public static AWSEC2TemplateOptions inboundPorts(int ... ports) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.inboundPorts(ports);
        }

        public static AWSEC2TemplateOptions blockOnPort(int port, int seconds) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static AWSEC2TemplateOptions installPrivateKey(String rsaKey) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static AWSEC2TemplateOptions authorizePublicKey(String rsaKey) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static AWSEC2TemplateOptions subnetId(String subnetId) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.subnetId(subnetId);
        }

        public static AWSEC2TemplateOptions spotPrice(Float spotPrice) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.spotPrice(spotPrice);
        }

        public static AWSEC2TemplateOptions spotOptions(RequestSpotInstancesOptions spotOptions) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.spotOptions(spotOptions);
        }

        public static AWSEC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static AWSEC2TemplateOptions userMetadata(String key, String value) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.userMetadata(key, value));
        }
    }
}

