/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml.ovf;

import java.util.Map;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.ovf.EditableResourceAllocationSettingData;
import org.jclouds.vcloud.domain.ovf.VCloudHardDisk;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkAdapter;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;

public class VCloudResourceAllocationSettingDataHandler
extends ResourceAllocationSettingDataHandler {
    private ReferenceType edit;
    private long capacity;
    private int busType;
    private String busSubType;
    private String ipAddress;
    private boolean primaryNetworkConnection;
    private String ipAddressingMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceAllocationSettingData getResult() {
        try {
            ResourceAllocationSettingData from = super.getResult();
            if (this.edit != null) {
                EditableResourceAllocationSettingData editableResourceAllocationSettingData = EditableResourceAllocationSettingData.builder().fromResourceAllocationSettingData(from).edit(this.edit).build();
                return editableResourceAllocationSettingData;
            }
            if (this.busSubType != null) {
                VCloudHardDisk vCloudHardDisk = VCloudHardDisk.builder().fromResourceAllocationSettingData(from).capacity(this.capacity).busType(this.busType).busSubType(this.busSubType).build();
                return vCloudHardDisk;
            }
            if (this.ipAddress != null) {
                VCloudNetworkAdapter vCloudNetworkAdapter = VCloudNetworkAdapter.builder().fromResourceAllocationSettingData(from).ipAddress(this.ipAddress).primaryNetworkConnection(this.primaryNetworkConnection).ipAddressingMode(this.ipAddressingMode).build();
                return vCloudNetworkAdapter;
            }
            ResourceAllocationSettingData resourceAllocationSettingData = from;
            return resourceAllocationSettingData;
        }
        finally {
            this.ipAddress = null;
            this.primaryNetworkConnection = false;
            this.ipAddressingMode = null;
            this.capacity = -1L;
            this.busType = -1;
            this.busSubType = null;
            this.edit = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.endsWith("Link")) {
            this.edit = Utils.newReferenceType(attributes);
        } else if (qName.endsWith("HostResource") && attributes.size() > 0) {
            this.capacity = Long.parseLong(attributes.get("capacity"));
            this.busType = Integer.parseInt(attributes.get("busType"));
            this.busSubType = attributes.get("busSubType");
        } else if (qName.endsWith("Connection") && attributes.size() > 0) {
            this.ipAddress = attributes.get("ipAddress");
            this.primaryNetworkConnection = Boolean.parseBoolean(attributes.get("primaryNetworkConnection"));
            this.ipAddressingMode = attributes.get("ipAddressingMode");
        }
        super.startElement(uri, localName, qName, attrs);
    }
}

