/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.vcloud.binders.BindCPUCountToXmlPayload;
import org.jclouds.vcloud.binders.BindDeployVAppParamsToXmlPayload;
import org.jclouds.vcloud.binders.BindGuestCustomizationSectionToXmlPayload;
import org.jclouds.vcloud.binders.BindMemoryToXmlPayload;
import org.jclouds.vcloud.binders.BindNetworkConnectionSectionToXmlPayload;
import org.jclouds.vcloud.binders.BindUndeployVAppParamsToXmlPayload;
import org.jclouds.vcloud.domain.GuestCustomizationSection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VmHandler;

@RequestFilters(value={AddVCloudAuthorizationAndCookieToRequest.class})
public interface VmAsyncClient {
    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vm+xml"})
    @XMLResponseParser(value=VmHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Vm> getVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.deployVAppParams+xml"})
    @Path(value="/action/deploy")
    @MapBinder(value=BindDeployVAppParamsToXmlPayload.class)
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> deployVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.deployVAppParams+xml"})
    @Path(value="/action/deploy")
    @MapBinder(value=BindDeployVAppParamsToXmlPayload.class)
    @PayloadParams(keys={"powerOn"}, values={"true"})
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> deployAndPowerOnVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.undeployVAppParams+xml"})
    @Path(value="/action/undeploy")
    @MapBinder(value=BindUndeployVAppParamsToXmlPayload.class)
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> undeployVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.undeployVAppParams+xml"})
    @Path(value="/action/undeploy")
    @MapBinder(value=BindUndeployVAppParamsToXmlPayload.class)
    @PayloadParams(keys={"saveState"}, values={"true"})
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> undeployAndSaveStateOfVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/powerOn")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> powerOnVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/powerOff")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> powerOffVm(@EndpointParam URI var1);

    @POST
    @Path(value="/power/action/shutdown")
    public ListenableFuture<Void> shutdownVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/reset")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> resetVm(@EndpointParam URI var1);

    @POST
    @Path(value="/power/action/reboot")
    public ListenableFuture<Void> rebootVm(@EndpointParam URI var1);

    @POST
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Path(value="/power/action/suspend")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> suspendVm(@EndpointParam URI var1);

    @PUT
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.rasdItem+xml"})
    @Path(value="/virtualHardwareSection/cpu")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> updateCPUCountOfVm(@BinderParam(value=BindCPUCountToXmlPayload.class) int var1, @EndpointParam URI var2);

    @PUT
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.rasdItem+xml"})
    @Path(value="/virtualHardwareSection/memory")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> updateMemoryMBOfVm(@BinderParam(value=BindMemoryToXmlPayload.class) int var1, @EndpointParam URI var2);

    @PUT
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.guestCustomizationSection+xml"})
    @Path(value="/guestCustomizationSection")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> updateGuestCustomizationOfVm(@BinderParam(value=BindGuestCustomizationSectionToXmlPayload.class) GuestCustomizationSection var1, @EndpointParam URI var2);

    @PUT
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Produces(value={"application/vnd.vmware.vcloud.networkConnectionSection+xml"})
    @Path(value="/networkConnectionSection")
    @XMLResponseParser(value=TaskHandler.class)
    public ListenableFuture<Task> updateNetworkConnectionOfVm(@BinderParam(value=BindNetworkConnectionSectionToXmlPayload.class) NetworkConnectionSection var1, @EndpointParam URI var2);

    @GET
    @Path(value="/screen")
    @Consumes(value={"image/png"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<InputStream> getScreenThumbnailForVm(@EndpointParam URI var1);
}

