/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.ovf;

import java.net.URI;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.ovf.Section;
import org.jclouds.ovf.VirtualHardwareSection;

public class VCloudVirtualHardwareSection
extends VirtualHardwareSection {
    protected final String type;
    protected final URI href;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return VCloudVirtualHardwareSection.builder().fromVCloudVirtualHardwareSection(this);
    }

    public VCloudVirtualHardwareSection(String type, URI href, String info, Iterable<String> transports, VirtualSystemSettingData virtualSystem, Iterable<? extends ResourceAllocationSettingData> resourceAllocations) {
        super(info, transports, virtualSystem, resourceAllocations);
        this.type = type;
        this.href = href;
    }

    public String getType() {
        return this.type;
    }

    public URI getHref() {
        return this.href;
    }

    @Override
    public int hashCode() {
        return this.href.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCloudVirtualHardwareSection other = (VCloudVirtualHardwareSection)obj;
        return this.href.equals(other.href);
    }

    @Override
    public String toString() {
        return "[href=" + this.getHref() + ", type=" + this.getType() + ", info=" + this.getInfo() + ", virtualSystem=" + this.getSystem() + "]";
    }

    public static class Builder
    extends VirtualHardwareSection.Builder {
        protected String type;
        protected URI href;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        @Override
        public Builder system(VirtualSystemSettingData virtualSystem) {
            return (Builder)Builder.class.cast(super.system(virtualSystem));
        }

        @Override
        public Builder transport(String transport) {
            return (Builder)Builder.class.cast(super.transport(transport));
        }

        @Override
        public Builder transports(Iterable<String> transports) {
            return (Builder)Builder.class.cast(super.transports(transports));
        }

        @Override
        public Builder item(ResourceAllocationSettingData item) {
            return (Builder)Builder.class.cast(super.item(item));
        }

        @Override
        public Builder items(Iterable<? extends ResourceAllocationSettingData> items) {
            return (Builder)Builder.class.cast(super.items(items));
        }

        @Override
        public VCloudVirtualHardwareSection build() {
            return new VCloudVirtualHardwareSection(this.type, this.href, this.info, this.transports, this.virtualSystem, this.items);
        }

        public Builder fromVCloudVirtualHardwareSection(VCloudVirtualHardwareSection in) {
            return this.fromVirtualHardwareSection(in).type(in.getType()).href(in.getHref());
        }

        @Override
        public Builder fromVirtualHardwareSection(VirtualHardwareSection in) {
            return (Builder)Builder.class.cast(super.fromVirtualHardwareSection(in));
        }

        @Override
        public Builder fromSection(Section<VirtualHardwareSection> in) {
            return (Builder)Builder.class.cast(super.fromSection((Section)in));
        }

        @Override
        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }
    }
}

