/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum NatPolicy {
    ALLOW_TRAFFIC,
    ALLOW_TRAFFIC_IN,
    UNRECOGNIZED;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static NatPolicy fromValue(String policy) {
        try {
            return NatPolicy.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(policy, "policy")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

