/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Objects;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.IpRange;

public class DhcpService {
    private final boolean enabled;
    @Nullable
    private final Integer defaultLeaseTime;
    @Nullable
    private final Integer maxLeaseTime;
    @Nullable
    private final IpRange ipRange;

    public DhcpService(boolean enabled, @Nullable Integer defaultLeaseTime, @Nullable Integer maxLeaseTime, @Nullable IpRange ipRange) {
        this.enabled = enabled;
        this.defaultLeaseTime = defaultLeaseTime;
        this.maxLeaseTime = maxLeaseTime;
        this.ipRange = ipRange;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public Integer getDefaultLeaseTime() {
        return this.defaultLeaseTime;
    }

    @Nullable
    public Integer getMaxLeaseTime() {
        return this.maxLeaseTime;
    }

    @Nullable
    public IpRange getIpRange() {
        return this.ipRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DhcpService that = (DhcpService)DhcpService.class.cast(o);
        return Objects.equal(this.enabled, that.enabled) && Objects.equal(this.defaultLeaseTime, that.defaultLeaseTime) && Objects.equal(this.maxLeaseTime, that.maxLeaseTime) && Objects.equal(this.ipRange, that.ipRange);
    }

    public int hashCode() {
        return Objects.hashCode(this.enabled, this.defaultLeaseTime, this.maxLeaseTime, this.ipRange);
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("enabled", this.enabled).add("defaultLeaseTime", this.defaultLeaseTime).add("maxLeaseTime", this.maxLeaseTime).add("ipRange", this.ipRange).toString();
    }
}

