/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.io.Resources;
import java.net.URL;

public class ClassLoadingUtils {
    public static Class<?> loadClass(Class<?> contextClass, String className) {
        Class<?> clazz = null;
        if (contextClass.getClassLoader() != null) {
            clazz = ClassLoadingUtils.silentLoadClass(className, contextClass.getClassLoader());
        }
        if (clazz == null && Thread.currentThread().getContextClassLoader() != null) {
            clazz = ClassLoadingUtils.silentLoadClass(className, Thread.currentThread().getContextClassLoader());
        }
        return clazz;
    }

    public static URL loadResource(Class<?> contextClass, String resourceName) {
        URL url = null;
        if (contextClass != null) {
            url = Resources.getResource(contextClass, resourceName);
        }
        if (url == null && Thread.currentThread().getContextClassLoader() != null) {
            url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        }
        return url;
    }

    private static Class<?> silentLoadClass(String className, ClassLoader classLoader) {
        Class<?> clazz = null;
        if (classLoader != null && className != null) {
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }
}

