/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.domain.internal.VDCImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VDCHandler
extends ParseSax.HandlerWithResult<VDC> {
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType vDC;
    protected String description;
    protected Map<String, ReferenceType> resourceEntities = Maps.newLinkedHashMap();
    protected Map<String, ReferenceType> availableNetworks = Maps.newLinkedHashMap();
    private ReferenceType catalog;
    private ReferenceType publicIps;
    private ReferenceType internetServices;

    @Override
    public VDC getResult() {
        return new VDCImpl(this.vDC.getName(), this.vDC.getType(), this.vDC.getHref(), this.description, this.catalog, this.publicIps, this.internetServices, this.resourceEntities, this.availableNetworks);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        super.startElement(uri, localName, qName, attrs);
        if (qName.endsWith("Vdc")) {
            this.vDC = Utils.newReferenceType(attributes);
        } else if (qName.endsWith("Network")) {
            Utils.putReferenceType(this.availableNetworks, attributes);
        } else if (qName.endsWith("ResourceEntity")) {
            Utils.putReferenceType(this.resourceEntities, attributes);
        } else if (SaxUtils.equalsOrSuffix(qName, "Link")) {
            String name = attributes.get("name");
            if (name.equals("Internet Services")) {
                this.internetServices = Utils.newReferenceType(attributes);
            } else if (name.equals("Public IPs")) {
                this.publicIps = Utils.newReferenceType(attributes);
            } else {
                String type = attributes.get("type");
                if (type.equals("application/vnd.vmware.vcloud.catalog+xml")) {
                    this.catalog = Utils.newReferenceType(attributes);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Description")) {
            this.description = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

