/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;

public class VDCImpl
extends ReferenceTypeImpl
implements VDC {
    @Nullable
    private final String description;
    private final ReferenceType catalog;
    private final ReferenceType publicIps;
    private final ReferenceType internetServices;
    private final Map<String, ReferenceType> resourceEntities;
    private final Map<String, ReferenceType> availableNetworks;

    public VDCImpl(String name, String type, URI href, @Nullable String description, ReferenceType catalog, ReferenceType publicIps, ReferenceType internetServices, Map<String, ReferenceType> resourceEntities, Map<String, ReferenceType> availableNetworks) {
        super(name, type, href);
        this.description = description;
        this.catalog = Preconditions.checkNotNull(catalog, "catalog");
        this.publicIps = Preconditions.checkNotNull(publicIps, "publicIps");
        this.internetServices = Preconditions.checkNotNull(internetServices, "internetServices");
        this.resourceEntities = ImmutableMap.copyOf(Preconditions.checkNotNull(resourceEntities, "resourceEntities"));
        this.availableNetworks = ImmutableMap.copyOf(Preconditions.checkNotNull(availableNetworks, "availableNetworks"));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ReferenceType getCatalog() {
        return this.catalog;
    }

    @Override
    public ReferenceType getPublicIps() {
        return this.publicIps;
    }

    @Override
    public ReferenceType getInternetServices() {
        return this.internetServices;
    }

    @Override
    public Map<String, ReferenceType> getResourceEntities() {
        return this.resourceEntities;
    }

    @Override
    public Map<String, ReferenceType> getAvailableNetworks() {
        return this.availableNetworks;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.availableNetworks == null ? 0 : ((Object)this.availableNetworks).hashCode());
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.internetServices == null ? 0 : this.internetServices.hashCode());
        result = 31 * result + (this.publicIps == null ? 0 : this.publicIps.hashCode());
        result = 31 * result + (this.resourceEntities == null ? 0 : ((Object)this.resourceEntities).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VDCImpl other = (VDCImpl)obj;
        if (this.availableNetworks == null ? other.availableNetworks != null : !((Object)this.availableNetworks).equals(other.availableNetworks)) {
            return false;
        }
        if (this.catalog == null ? other.catalog != null : !this.catalog.equals(other.catalog)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.internetServices == null ? other.internetServices != null : !this.internetServices.equals(other.internetServices)) {
            return false;
        }
        if (this.publicIps == null ? other.publicIps != null : !this.publicIps.equals(other.publicIps)) {
            return false;
        }
        return !(this.resourceEntities == null ? other.resourceEntities != null : !((Object)this.resourceEntities).equals(other.resourceEntities));
    }

    @Override
    public String toString() {
        return "[name=" + this.getName() + ", href=" + this.getHref() + ", description=" + this.description + ", catalog=" + this.catalog + ", publicIps=" + this.publicIps + ", internetServices=" + this.internetServices + ", resourceEntities=" + this.resourceEntities + ", availableNetworks=" + this.availableNetworks + "]";
    }
}

