/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Objects;
import java.net.URI;

public class ComputePoolReference
implements Comparable<ComputePoolReference> {
    private final URI href;
    private final String name;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ComputePoolReference.builder().fromComputePoolReference(this);
    }

    public ComputePoolReference(URI href, String name) {
        this.href = href;
        this.name = name;
    }

    @Override
    public int compareTo(ComputePoolReference that) {
        return this == that ? 0 : this.getHref().compareTo(that.getHref());
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputePoolReference that = (ComputePoolReference)ComputePoolReference.class.cast(o);
        return Objects.equal(this.href, that.href) && Objects.equal(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.href, this.name);
    }

    public String toString() {
        return Objects.toStringHelper("").add("href", this.href).add("name", this.name).toString();
    }

    public static class Builder {
        private URI href;
        private String name;

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public ComputePoolReference build() {
            return new ComputePoolReference(this.href, this.name);
        }

        public Builder fromComputePoolReference(ComputePoolReference in) {
            return this.href(in.getHref()).name(in.getName());
        }
    }
}

