/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;

@Singleton
public class TerremarkVCloudGetNodeMetadataStrategy
implements GetNodeMetadataStrategy {
    protected final TerremarkVCloudClient client;
    protected final Function<VApp, NodeMetadata> vAppToNodeMetadata;

    @Inject
    protected TerremarkVCloudGetNodeMetadataStrategy(TerremarkVCloudClient client, Function<VApp, NodeMetadata> vAppToNodeMetadata) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.vAppToNodeMetadata = vAppToNodeMetadata;
    }

    @Override
    public NodeMetadata getNode(String in) {
        URI id = URI.create(in);
        VApp from = this.client.getVApp(id);
        if (from == null) {
            return null;
        }
        return this.vAppToNodeMetadata.apply(from);
    }
}

