/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;
import org.jclouds.util.Throwables2;

@Singleton
public class CreateUniqueKeyPair
implements Function<OrgAndName, KeyPair> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final TerremarkVCloudClient trmkClient;
    protected Supplier<String> randomSuffix;

    @Inject
    CreateUniqueKeyPair(TerremarkVCloudClient trmkClient, Supplier<String> randomSuffix) {
        this.trmkClient = trmkClient;
        this.randomSuffix = randomSuffix;
    }

    @Override
    public KeyPair apply(OrgAndName from) {
        return this.createNewKeyPairInOrg(from.getOrg(), from.getName());
    }

    private KeyPair createNewKeyPairInOrg(URI org, String keyPairName) {
        Preconditions.checkNotNull(org, "org");
        Preconditions.checkNotNull(keyPairName, "keyPairName");
        this.logger.debug(">> creating keyPair org(%s) name(%s)", org, keyPairName);
        KeyPair keyPair = null;
        while (keyPair == null) {
            try {
                keyPair = this.trmkClient.generateKeyPairInOrg(org, this.getNextName(keyPairName), false);
                this.logger.debug("<< created keyPair(%s)", keyPair.getName());
            }
            catch (RuntimeException e) {
                HttpResponseException ht = Throwables2.getFirstThrowableOfType(e, HttpResponseException.class);
                if (ht != null && ht.getContent() != null && ht.getContent().indexOf("Security key with same name exists") != -1) continue;
                throw e;
            }
        }
        return keyPair;
    }

    private String getNextName(String keyPairName) {
        return "jclouds_" + keyPairName.replaceAll("-", "_") + "_" + this.randomSuffix.get();
    }
}

