/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCodes;
import java.util.Map;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sqs.domain.MessageIdAndMD5;
import org.jclouds.util.SaxUtils;

public class SendMessageBatchResultEntryHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Map.Entry<String, MessageIdAndMD5>> {
    private StringBuilder currentText = new StringBuilder();
    private MessageIdAndMD5.Builder builder = MessageIdAndMD5.builder();
    private String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry<String, MessageIdAndMD5> getResult() {
        try {
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(ImmutableMap.of(this.id, this.builder.build()).entrySet());
            return entry;
        }
        finally {
            this.builder = MessageIdAndMD5.builder();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Id")) {
            this.id = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("MessageId")) {
            this.builder.id(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("MD5OfMessageBody")) {
            this.builder.md5(HashCodes.fromBytes(CryptoStreams.hex(SaxUtils.currentOrNull(this.currentText))));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

