/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class BatchError {
    private final String id;
    private final boolean senderFault;
    private final String code;
    private final String message;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return BatchError.builder().fromErrorEntry(this);
    }

    private BatchError(String id, boolean senderFault, String code, String message) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.senderFault = Preconditions.checkNotNull(senderFault, "senderFault of %s", id);
        this.code = Preconditions.checkNotNull(code, "code of %s", id);
        this.message = Preconditions.checkNotNull(message, "message of %s", id);
    }

    public String getId() {
        return this.id;
    }

    public boolean isSenderFault() {
        return this.senderFault;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BatchError that = (BatchError)BatchError.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("id", this.id).add("senderFault", this.senderFault).add("message", this.message).add("code", this.code).toString();
    }

    public static class Builder {
        private String id;
        private boolean senderFault;
        private String code;
        private String message;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder senderFault(boolean senderFault) {
            this.senderFault = senderFault;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public BatchError build() {
            return new BatchError(this.id, this.senderFault, this.code, this.message);
        }

        public Builder fromErrorEntry(BatchError in) {
            return this.id(in.getId()).senderFault(in.isSenderFault()).code(in.getCode()).message(in.getMessage());
        }
    }
}

