/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Region
implements Comparable<Region> {
    private final int sortOrder;
    private final String keyname;
    private final String description;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"sortOrder", "keyname", "description"})
    public Region(int sortOrder, String keyname, String description) {
        this.sortOrder = sortOrder;
        this.keyname = Preconditions.checkNotNull(Strings.emptyToNull(keyname), "keyname cannot be null or empty:" + keyname);
        this.description = description;
    }

    @Override
    public int compareTo(Region arg0) {
        return Integer.valueOf(this.sortOrder).compareTo(arg0.sortOrder);
    }

    public String getKeyname() {
        return this.keyname;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Builder toBuilder() {
        return Builder.fromAddress(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return Objects.equal(this.keyname, region.keyname) && Objects.equal(this.description, region.description);
    }

    public int hashCode() {
        return Objects.hashCode(this.keyname, this.description);
    }

    public String toString() {
        return "[keyname=" + this.keyname + ", description=" + this.description + "]";
    }

    public static class Builder {
        private String keyname;
        private String description;

        public Builder keyname(String keyname) {
            this.keyname = keyname;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Region build() {
            return new Region(0, this.keyname, this.description);
        }

        public static Builder fromAddress(Region in) {
            return Region.builder().keyname(in.getKeyname()).description(in.getDescription());
        }
    }
}

