/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;
import org.jclouds.softlayer.SoftLayerAsyncClient;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.config.SoftLayerComputeServiceContextModule;
import org.jclouds.softlayer.config.SoftLayerRestClientModule;

public class SoftLayerApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 6725672099385580694L;
    public static final TypeToken<RestContext<SoftLayerClient, SoftLayerAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<SoftLayerClient, SoftLayerAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public SoftLayerApiMetadata() {
        this(new Builder());
    }

    protected SoftLayerApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.ssh.max-retries", "5");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(SoftLayerClient.class, SoftLayerAsyncClient.class);
            ((BaseApiMetadata.Builder)this.id("softlayer").name("SoftLayer API").identityName("API Username").credentialName("API Key").documentation(URI.create("http://sldn.softlayer.com/article/REST")).version("3").defaultEndpoint("https://api.softlayer.com/rest").defaultProperties(SoftLayerApiMetadata.defaultProperties()).view(TypeToken.of(ComputeServiceContext.class))).defaultModules(ImmutableSet.of(SoftLayerRestClientModule.class, SoftLayerComputeServiceContextModule.class));
        }

        @Override
        public SoftLayerApiMetadata build() {
            return new SoftLayerApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

