/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.slicehost.domain.Flavor;
import org.jclouds.slicehost.xml.FlavorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FlavorsHandler
extends ParseSax.HandlerWithResult<Set<? extends Flavor>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Flavor> slices = Sets.newLinkedHashSet();
    private final FlavorHandler locationHandler;

    @Inject
    public FlavorsHandler(FlavorHandler locationHandler) {
        this.locationHandler = locationHandler;
    }

    @Override
    public Set<? extends Flavor> getResult() {
        return this.slices;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.locationHandler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.locationHandler.endElement(uri, localName, qName);
        if (qName.equals("flavor") && this.currentText.toString().trim().equals("")) {
            this.slices.add(this.locationHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.locationHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

