/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.S3Client;
import org.jclouds.util.Patterns;

public class S3Utils {
    public static final Pattern BUCKET_NAME_PATTERN = Pattern.compile("^[a-z0-9][-_.a-z0-9]+");
    private static final Predicate<Annotation> ANNOTATIONTYPE_BUCKET = new Predicate<Annotation>(){

        @Override
        public boolean apply(Annotation input) {
            return input.annotationType().equals(Bucket.class);
        }
    };

    public static String validateBucketName(String bucketName) {
        Preconditions.checkNotNull(bucketName, "bucketName");
        Preconditions.checkArgument(BUCKET_NAME_PATTERN.matcher(bucketName).matches(), "bucketName name must start with a number or letter and  can only contain lowercase letters, numbers, periods (.), underscores (_), and dashes (-)");
        Preconditions.checkArgument(bucketName.length() > 2 && bucketName.length() < 256, "bucketName name must be between 3 and 255 characters long");
        Preconditions.checkArgument(!Patterns.IP_PATTERN.matcher(bucketName).matches(), "bucketName name cannot be ip address style");
        return bucketName;
    }

    public static boolean deleteAndVerifyContainerGone(S3Client sync, String container) {
        sync.deleteBucketIfEmpty(container);
        return !sync.bucketExists(container);
    }

    public static String getBucketName(HttpRequest req) {
        Preconditions.checkArgument(req instanceof GeneratedHttpRequest, "this should be a generated http request");
        GeneratedHttpRequest request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(req);
        String bucketName = null;
        for (int i = 0; i < request.getJavaMethod().getParameterAnnotations().length; ++i) {
            if (!Iterables.any(Arrays.asList(request.getJavaMethod().getParameterAnnotations()[i]), ANNOTATIONTYPE_BUCKET)) continue;
            bucketName = (String)request.getArgs().get(i);
            break;
        }
        return bucketName;
    }
}

