/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import javax.inject.Singleton;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Throwables2;

@Singleton
public class ReturnTrueOn404OrNotFoundFalseOnIllegalState
implements Function<Exception, Boolean> {
    @Override
    public Boolean apply(Exception from) {
        if (Throwables2.getFirstThrowableOfType(from, IllegalStateException.class) != null) {
            return false;
        }
        if (Throwables2.getFirstThrowableOfType(from, ContainerNotFoundException.class) != null) {
            return true;
        }
        if (HttpUtils.returnValueOnCodeOrNull(from, true, Predicates.equalTo(404)) != null) {
            return true;
        }
        throw Throwables.propagate(from);
    }
}

