/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;

@Singleton
public class RimuHostingAuthentication
implements HttpRequestFilter {
    private final String header;

    @Inject
    public RimuHostingAuthentication(@Provider Supplier<Credentials> creds) {
        this.header = String.format("rimuhosting apikey=%s", Preconditions.checkNotNull(creds, (Object)"creds").get().identity);
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", this.header)).build();
    }
}

