/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.data;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.jclouds.rimuhosting.miro.data.CloneOptions;
import org.jclouds.rimuhosting.miro.data.CreateOptions;
import org.jclouds.rimuhosting.miro.data.IpRequestData;
import org.jclouds.rimuhosting.miro.data.PostData;
import org.jclouds.rimuhosting.miro.domain.MetaData;
import org.jclouds.rimuhosting.miro.domain.PricingPlan;
import org.jclouds.rimuhosting.miro.domain.ServerParameters;

public class NewServerData
implements PostData {
    @SerializedName(value="billing_oid")
    private Long billingId;
    @SerializedName(value="host_server_oid")
    private String hostServerId;
    @SerializedName(value="instantiation_options")
    private CreateOptions createOptions;
    @SerializedName(value="instantiation_via_clone_options")
    private CloneOptions cloneOptions;
    @SerializedName(value="ip_request")
    private IpRequestData ipRequest;
    @SerializedName(value="pricing_plan_code")
    private String planId;
    @SerializedName(value="user_oid")
    private Long userId;
    @SerializedName(value="vps_parameters")
    private ServerParameters serverParameters;
    @SerializedName(value="meta_data")
    private List<MetaData> metaData;

    public NewServerData() {
    }

    public NewServerData(CreateOptions createOptions, PricingPlan pricingPlan) {
        this.createOptions = createOptions;
        if (pricingPlan != null) {
            this.planId = pricingPlan.getId();
        }
    }

    public NewServerData(CreateOptions createOptions, String pricingPlanId) {
        this.createOptions = createOptions;
        this.planId = pricingPlanId;
    }

    public NewServerData(CloneOptions cloneOptions) {
        this.cloneOptions = cloneOptions;
    }

    public Long getBillingId() {
        return this.billingId;
    }

    public void setBillingId(Long billingId) {
        this.billingId = billingId;
    }

    public String getHostServerId() {
        return this.hostServerId;
    }

    public void setHostServerId(String hostServerId) {
        this.hostServerId = hostServerId;
    }

    public CreateOptions getCreateOptions() {
        return this.createOptions;
    }

    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    public CloneOptions getCloneOptions() {
        return this.cloneOptions;
    }

    public void setCloneOptions(CloneOptions cloneOptions) {
        this.cloneOptions = cloneOptions;
    }

    public IpRequestData getIpRequest() {
        return this.ipRequest;
    }

    public void setIpRequest(IpRequestData ipRequest) {
        this.ipRequest = ipRequest;
    }

    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public ServerParameters getInstanceParameters() {
        return this.serverParameters;
    }

    public void setInstanceParameters(ServerParameters serverParameters) {
        this.serverParameters = serverParameters;
    }

    @Override
    public void validate() {
        assert (this.cloneOptions == null ^ this.createOptions == null);
        if (this.cloneOptions != null) {
            this.cloneOptions.validate();
        }
        if (this.createOptions != null) {
            this.createOptions.validate();
            assert (this.planId != null && this.planId.length() == 0);
        }
        if (this.ipRequest != null) {
            this.ipRequest.validate();
        }
        if (this.serverParameters != null) {
            this.serverParameters.validate();
        }
    }

    public void setMetaData(List<MetaData> metaData) {
        this.metaData = metaData;
    }

    public List<MetaData> getMetaData() {
        return this.metaData;
    }
}

