/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.functions.LB;
import org.jclouds.rest.InvocationContext;

public class ParseLoadBalancers
implements Function<HttpResponse, IterableWithMarker<LoadBalancer>>,
InvocationContext<ParseLoadBalancers> {
    private final ParseJson<LoadBalancers> json;
    private final ConvertLB.Factory factory;
    private ConvertLB convertLB;

    @Inject
    ParseLoadBalancers(ParseJson<LoadBalancers> json, ConvertLB.Factory factory) {
        this.json = Preconditions.checkNotNull(json, "json");
        this.factory = Preconditions.checkNotNull(factory, "factory");
    }

    @Override
    public IterableWithMarker<LoadBalancer> apply(HttpResponse arg0) {
        LoadBalancers lbs = this.json.apply(arg0);
        if (lbs.size() == 0) {
            return IterableWithMarkers.EMPTY;
        }
        Iterable<LoadBalancer> transform = Iterables.transform(lbs, this.convertLB);
        IterableWithMarker<LoadBalancer> iterableWithMarker = IterableWithMarkers.from(transform);
        return iterableWithMarker;
    }

    @Override
    public ParseLoadBalancers setContext(HttpRequest request) {
        return this.setRegion(request.getEndpoint().getHost().substring(0, request.getEndpoint().getHost().indexOf(46)));
    }

    ParseLoadBalancers setRegion(String region) {
        this.convertLB = this.factory.createForRegion(region);
        return this;
    }

    public static class ToPagedIterable
    extends CallerArg0ToPagedIterable<LoadBalancer, ToPagedIterable> {
        private final CloudLoadBalancersApi api;

        @Inject
        protected ToPagedIterable(CloudLoadBalancersApi api) {
            this.api = Preconditions.checkNotNull(api, "api");
        }

        @Override
        protected Function<Object, IterableWithMarker<LoadBalancer>> markerToNextForCallingArg0(String zone) {
            final LoadBalancerApi loadBalancerApi = this.api.getLoadBalancerApiForZone(zone);
            return new Function<Object, IterableWithMarker<LoadBalancer>>(){

                @Override
                public IterableWithMarker<LoadBalancer> apply(Object input) {
                    IterableWithMarker<LoadBalancer> list = loadBalancerApi.list(PaginationOptions.Builder.marker(input.toString()));
                    return list;
                }

                public String toString() {
                    return "list()";
                }
            };
        }
    }

    static class LoadBalancers
    extends PaginatedCollection<LB> {
        @ConstructorProperties(value={"loadBalancers", "loadBalancers_links"})
        protected LoadBalancers(Iterable<LB> loadBalancers, Iterable<Link> loadBalancers_links) {
            super(loadBalancers, loadBalancers_links);
        }
    }
}

