/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.functions.ReturnEmptyPaginatedCollectionOnNotFoundOr404;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.domain.NodeAttributes;
import org.jclouds.rackspace.cloudloadbalancers.domain.NodeRequest;
import org.jclouds.rackspace.cloudloadbalancers.functions.ParseNodes;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.ReturnEmptyPagedIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={AuthenticateRequest.class})
public interface NodeAsyncApi {
    @POST
    @SelectJson(value={"nodes"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/nodes")
    public ListenableFuture<Set<Node>> add(@WrapWith(value="nodes") Iterable<NodeRequest> var1);

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/nodes/{id}")
    public ListenableFuture<Void> update(@PathParam(value="id") int var1, @WrapWith(value="node") NodeAttributes var2);

    @GET
    @ResponseParser(value=ParseNodes.class)
    @Transform(value=ParseNodes.ToPagedIterable.class)
    @Consumes(value={"application/json"})
    @Path(value="/nodes")
    @ExceptionParser(value=ReturnEmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<PagedIterable<Node>> list();

    @GET
    @ResponseParser(value=ParseNodes.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/loadbalancers")
    public ListenableFuture<IterableWithMarker<LoadBalancer>> list(PaginationOptions var1);

    @GET
    @SelectJson(value={"node"})
    @Consumes(value={"application/json"})
    @Path(value="/nodes/{id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Node> get(@PathParam(value="id") int var1);

    @DELETE
    @Path(value="/nodes/{id}")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> remove(@PathParam(value="id") int var1);

    @DELETE
    @Path(value="/nodes")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    public ListenableFuture<Void> remove(@QueryParam(value="id") Iterable<Integer> var1);
}

