/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.annotations.Api;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BuildVersion;

public class BindProviderMetadataContextAndCredentials
extends AbstractModule {
    private final ProviderMetadata providerMetadata;
    private final Supplier<Credentials> creds;

    public BindProviderMetadataContextAndCredentials(ProviderMetadata providerMetadata, Supplier<Credentials> creds) {
        this.providerMetadata = Preconditions.checkNotNull(providerMetadata, "providerMetadata");
        this.creds = Preconditions.checkNotNull(creds, "creds");
    }

    @Override
    protected void configure() {
        this.bind(ProviderMetadata.class).toInstance(this.providerMetadata);
        Properties toBind = new Properties();
        toBind.putAll((Map<?, ?>)this.providerMetadata.getApiMetadata().getDefaultProperties());
        toBind.putAll((Map<?, ?>)this.providerMetadata.getDefaultProperties());
        Names.bindProperties(this.binder(), toBind);
        this.bind(new TypeLiteral<Supplier<Credentials>>(){}).annotatedWith(Provider.class).toInstance(this.creds);
        this.bindConstant().annotatedWith(Provider.class).to(this.providerMetadata.getId());
        this.bind(new TypeLiteral<Set<String>>(){}).annotatedWith(Iso3166.class).toInstance(this.providerMetadata.getIso3166Codes());
        this.bindConstant().annotatedWith(Api.class).to(this.providerMetadata.getApiMetadata().getId());
        this.bindConstant().annotatedWith(ApiVersion.class).to(this.providerMetadata.getApiMetadata().getVersion());
        this.bind(String.class).annotatedWith(BuildVersion.class).toProvider(Providers.of(this.providerMetadata.getApiMetadata().getBuildVersion().orNull()));
        this.bind(new TypeLiteral<TypeToken<? extends Context>>(){}).annotatedWith(Provider.class).toInstance(this.providerMetadata.getApiMetadata().getContext());
    }

    @Provides
    @Provider
    @Singleton
    protected Context backend(Injector i, @Provider TypeToken<? extends Context> backendType) {
        return (Context)Context.class.cast(i.getInstance(Key.get(TypeLiteral.get(backendType.getType()))));
    }
}

