/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class Extension
extends Resource {
    private final URI namespace;
    private final String alias;
    private final Date updated;
    private final String description;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromExtension(this);
    }

    @ConstructorProperties(value={"name", "links", "namespace", "alias", "updated", "description"})
    protected Extension(@Nullable String name, Set<Link> links, URI namespace, String alias, @Nullable Date updated, String description) {
        super(alias, name, links);
        this.namespace = Preconditions.checkNotNull(namespace, "namespace");
        this.alias = Preconditions.checkNotNull(alias, "alias");
        this.updated = updated;
        this.description = Preconditions.checkNotNull(description, "description");
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String getAlias() {
        return this.alias;
    }

    @Nullable
    public Date getUpdated() {
        return this.updated;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.namespace, this.alias, this.updated, this.description);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Extension that = (Extension)Extension.class.cast(obj);
        return super.equals(that) && Objects.equal(this.namespace, that.namespace) && Objects.equal(this.alias, that.alias) && Objects.equal(this.updated, that.updated) && Objects.equal(this.description, that.description);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("namespace", this.namespace).add("alias", this.alias).add("updated", this.updated).add("description", this.description);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected URI namespace;
        protected String alias;
        protected Date updated;
        protected String description;

        public T namespace(URI namespace) {
            this.namespace = namespace;
            return (T)((Builder)this.self());
        }

        public T alias(String alias) {
            this.alias = alias;
            return (T)((Builder)this.self());
        }

        @Override
        public T id(String id) {
            return this.alias(id);
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Builder)this.self());
        }

        public T description(String description) {
            this.description = description;
            return (T)((Builder)this.self());
        }

        @Override
        public Extension build() {
            return new Extension(this.name, this.links, this.namespace, this.alias, this.updated, this.description);
        }

        public T fromExtension(Extension in) {
            return ((Builder)((Builder)((Builder)((Builder)super.fromResource(in)).namespace(in.getNamespace())).alias(in.getAlias())).updated(in.getUpdated())).description(in.getDescription());
        }
    }
}

