/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;

public class FindSecurityGroupOrCreate
extends CacheLoader<ZoneAndName, SecurityGroupInZone> {
    protected final Predicate<AtomicReference<ZoneAndName>> returnSecurityGroupExistsInZone;
    protected final Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> groupCreator;

    @Inject
    public FindSecurityGroupOrCreate(@Named(value="jclouds.openstack-nova.timeout.securitygroup-present") Predicate<AtomicReference<ZoneAndName>> returnSecurityGroupExistsInZone, Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> groupCreator) {
        this.returnSecurityGroupExistsInZone = Preconditions.checkNotNull(returnSecurityGroupExistsInZone, "returnSecurityGroupExistsInZone");
        this.groupCreator = Preconditions.checkNotNull(groupCreator, "groupCreator");
    }

    @Override
    public SecurityGroupInZone load(ZoneAndName in) {
        AtomicReference<ZoneAndName> securityGroupInZoneRef = new AtomicReference<ZoneAndName>(Preconditions.checkNotNull(in, "zoneSecurityGroupNameAndPorts"));
        if (this.returnSecurityGroupExistsInZone.apply(securityGroupInZoneRef)) {
            return this.returnExistingSecurityGroup(securityGroupInZoneRef);
        }
        return this.createNewSecurityGroup(in);
    }

    private SecurityGroupInZone returnExistingSecurityGroup(AtomicReference<ZoneAndName> securityGroupInZoneRef) {
        ZoneAndName securityGroupInZone = securityGroupInZoneRef.get();
        Preconditions.checkState(securityGroupInZone instanceof SecurityGroupInZone, "programming error: predicate %s should update the atomic reference to the actual security group found", this.returnSecurityGroupExistsInZone);
        return (SecurityGroupInZone)SecurityGroupInZone.class.cast(securityGroupInZone);
    }

    private SecurityGroupInZone createNewSecurityGroup(ZoneAndName in) {
        Preconditions.checkState(Preconditions.checkNotNull(in, "zoneSecurityGroupNameAndPorts") instanceof ZoneSecurityGroupNameAndPorts, "programming error: when issuing get to this cacheloader, you need to pass an instance of ZoneSecurityGroupNameAndPorts, not %s", in);
        ZoneSecurityGroupNameAndPorts zoneSecurityGroupNameAndPorts = (ZoneSecurityGroupNameAndPorts)ZoneSecurityGroupNameAndPorts.class.cast(in);
        return this.groupCreator.apply(zoneSecurityGroupNameAndPorts);
    }

    public String toString() {
        return "returnExistingSecurityGroupInZoneOrCreateAsNeeded()";
    }
}

