/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseTenants
extends ParseJson<Tenants<? extends Tenant>> {
    @Inject
    public ParseTenants(Json json) {
        super(json, new TypeLiteral<Tenants<? extends Tenant>>(){});
    }

    public static class ToPagedIterable
    extends CallerArg0ToPagedIterable<Tenant, ToPagedIterable> {
        private final KeystoneApi api;

        @Inject
        protected ToPagedIterable(KeystoneApi api) {
            this.api = Preconditions.checkNotNull(api, "api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Tenant>> markerToNextForCallingArg0(String ignored) {
            final TenantApi tenantApi = this.api.getTenantApi().get();
            return new Function<Object, IterableWithMarker<Tenant>>(){

                @Override
                public IterableWithMarker<Tenant> apply(Object input) {
                    return (IterableWithMarker)IterableWithMarker.class.cast(tenantApi.list(PaginationOptions.Builder.marker(input.toString())));
                }

                public String toString() {
                    return "listTenants()";
                }
            };
        }
    }

    static class Tenants<T extends Tenant>
    extends PaginatedCollection<T> {
        @ConstructorProperties(value={"tenants", "tenants_links"})
        protected Tenants(Iterable<T> tenants, Iterable<Link> tenants_links) {
            super(tenants, tenants_links);
        }
    }
}

