/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.http.utils.Queries;
import org.jclouds.openstack.v2_0.domain.Link;

@Beta
public class PaginatedCollection<T>
extends IterableWithMarker<T> {
    public static final PaginatedCollection EMPTY = new PaginatedCollection(ImmutableSet.of(), ImmutableSet.<Link>of());
    private Iterable<T> resources;
    private Iterable<Link> links;

    protected PaginatedCollection(Iterable<T> resources, Iterable<Link> links) {
        this.resources = resources != null ? resources : ImmutableSet.of();
        this.links = links != null ? links : ImmutableSet.of();
    }

    @Override
    public Iterator<T> iterator() {
        return this.resources.iterator();
    }

    public Iterable<Link> getLinks() {
        return this.links;
    }

    @Override
    public Optional<Object> nextMarker() {
        return FluentIterable.from(this.getLinks()).filter(new Predicate<Link>(){

            @Override
            public boolean apply(Link link) {
                return Link.Relation.NEXT == link.getRelation();
            }
        }).transform(new Function<Link, Optional<Object>>(){

            @Override
            public Optional<Object> apply(Link link) {
                Collection<String> markers = Queries.queryParser().apply(link.getHref().getRawQuery()).get("marker");
                return Optional.fromNullable(markers == null ? null : Iterables.get(markers, 0));
            }
        }).first().or(Optional.absent());
    }
}

